v1 <- runif(1000)
v2 <- runif(100000000)
# Using default nmath library
print("Serial nmath version timing:")
print("exp:")
system.time(exp(v2))
print("sqrt:")
system.time(sqrt(v2))
print("qtukey")
system.time(qtukey(v1,2,3))

# Using pnmath library
print("Parallel nmath timing:")
library("pnmath")                 #uses OpenMP
setNumPnmathThreads(4)
print(sprintf("Number of threads: %d", getNumPnmathThreads()))
print("exp:")
system.time(exp(v2))
print("sqrt:")
system.time(sqrt(v2))
print("qtukey")
system.time(qtukey(v1,2,3))
# To run this program on four cores on Nautilus:
# For pnmath                             | 
#-----------------------------------------
# export OMP_NUM_THREADS=4(in PBS script)| 
#        OR                              |
# setNumPnmathThreads(4)                 | 
