# Here is code that creates matrix x filled with random numbers from a normal distribution and calculates x(t) x three ways:

  #(1) Element by element, using the rule that we use "by hand" with %o% for the dot product.
  #(2) Using the matrix multiplication operation %o% to multiply x(t) by x.
  #(3) Using the statistics function crossprod(x).

its = 2500
dim = 1750

x <- matrix(rnorm(its*dim),its, dim)

# Single threaded breakup calculation
print("single threaded- breakup calculation")
system.time({
          result1 <- matrix(0,dim,dim)
                  for (i in 1:its)
                            result1 <- result1 + x[i,] %o% x[i,]
        })

print("multithreaded- BLAS matrix mult with 8 threads using %*% ")
system.time({result2 <- t(x) %*% x})

print("multithreaded- BLAS matrix mult with 8 threads using crossprod")
system.time({result3 <- crossprod(x)})

# To make sure that got the same answer from all three calculations.
print(all.equal(result1, result2, result3))

#To run this program on eight cores on Nautilus, you need to set following variables in PBS script:
#export MKL_NUM_THREADS=8
#export MKL_DYNAMICS=FALSE



