library(foreach)
library(doMC)
registerDoMC(2) #register the parallel backend with the foreach package and set the number of cores to use for parallel execution.
getDoParWorkers() #returns the number of execution workers.
getDoParRegistered() #returns TRUE if a doPar backend has been registered, otherwise FALSE.
getDoParName() #returns the name of the currently registered doPar backend.
getDoParVersion() #returns the version of the currently registered doPar backend.

# Simple example
foreach (j=1:4) %dopar% { j }
print("combine")
foreach (j=1:4,.combine=c) %dopar% { j }
print("summation")
foreach (j=1:4,.combine='+') %dopar% { j }

